﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using AuthenticationExample.Models;
using Microsoft.AspNetCore.Authorization;
using System.IO;

namespace AuthenticationExample.Controllers
{
    public class HomeController : Controller
    {
        [Authorize]
        public IActionResult Index()
        {
            return View();
        }

        [HttpGet("Callback")]
        public IActionResult Callback(dynamic response)
        {
            return RedirectToAction("Index");
        }

        [Authorize, HttpGet("SignOut")]
        public IActionResult SignOut()
        {
            return Redirect(Path.Combine("http://css.alimakgroup.com/authenticator", "Account", "LogOut"));
        }
    }
}
